/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.soo.dtoc;

import com.ibm.hwmca.fw.soo.dtoc.DTOCClient;
import com.ibm.hwmca.fw.soo.dtoc.ErrorDataException;
import com.ibm.hwmca.fw.soo.dtoc.MD5;
import com.ibm.hwmca.fw.soo.dtoc.decode;
import com.ibm.hwmca.fw.soo.dtoc.interp;
import com.ibm.hwmca.fw.soo.dtoc.mristr;
import com.ibm.hwmca.fw.soo.dtoc.receiv;
import com.ibm.hwmca.fw.soo.dtoc.sender;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class master
extends Panel
implements Runnable {
    final String Copyright = "Licensed Materials - Property of IBM     IBM Desktop On-Call   (c) Copyright IBM Corp.  1997.  All rights reserved.    US Government Users Restrictetd Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private InputStream input;
    private OutputStream output;
    private sender eventCmd = new sender(this);
    private receiv drawCmd = new receiv(this);
    private decode converter = new decode();
    private interp drawer = new interp();
    private mristr mri = new mristr();
    private Image bufferedImage;
    public Graphics bufferedScreen;
    public int screenWidth;
    public int screenHeight;
    public int imageWidth;
    public int imageHeight;
    public String host;
    public String hostIp;
    public String port;
    public int nBrowser;
    boolean fInitializing = true;
    boolean fTerminate;
    boolean fReload;
    boolean fDisconnect;
    boolean fAlternateButton;
    boolean fStarted = false;
    boolean fAlt;
    boolean fCtrl;
    byte[] byteUserId;
    byte[] bytePassword;
    boolean fAlreadyAuthenticated = false;
    Boolean fNegotiationSem = new Boolean(false);
    boolean fNegotiated = false;
    boolean[] fMode = new boolean[2];
    boolean fInsideScreen;
    int lastX;
    int lastY;
    public static final int DEFAULT_SLAVED_PORT = 25345;
    boolean fViewOnly;
    MediaTracker imageTracker = new MediaTracker(this);
    final String[] pictureSrcIBM = new String[]{"ctrl.gif", "alt.gif", "quit.gif", "insert.gif", "file.gif", "up.gif", "down.gif", "color.gif", "resize.gif", "mouse.gif"};
    char slash;
    DTOCClient client;
    String reason = null;
    private static final String TRACE_MASKT = "XDTCMSTT";
    private static final String TRACE_MASKF = "XDTCMSTF";
    private static final String TRACE_MASKD = "XDTCMSTD";

    public master(DTOCClient client) {
        this.client = client;
    }

    public void trace(int level, String mask, String text) {
        this.client.trace(level, mask, text);
    }

    public boolean connect(String serverAddress, int serverPort, String remoteUserid, char[] remotePassword, String HMCNetId, String HMCNAU, String HMCUserid, short HMCUserMode) {
        this.trace(2, TRACE_MASKT, "-> connect(" + serverAddress + ", " + serverPort + ", " + remoteUserid + ", <some_pwd>, " + HMCNetId + ", " + HMCNAU + ", " + HMCUserid + ", " + HMCUserMode + ")");
        this.trace(3, TRACE_MASKD, "Password=" + String.valueOf(remotePassword));
        this.reason = null;
        Socket slavedSocket = this.openSocket(serverAddress, serverPort);
        if (slavedSocket != null) {
            return this.connect(slavedSocket, remoteUserid, remotePassword, HMCNetId, HMCNAU, HMCUserid, HMCUserMode);
        }
        this.reason = "Unable to connect to the DTOC server: " + this.reason;
        this.fTerminate = true;
        return false;
    }

    public boolean connect(Socket slavedSocket, String remoteUserid, char[] remotePassword, String HMCNetId, String HMCNAU, String HMCUserid, short HMCUserMode) {
        try {
            this.input = slavedSocket.getInputStream();
            this.output = slavedSocket.getOutputStream();
            return this.connect(this.input, this.output, remoteUserid, remotePassword, HMCNetId, HMCNAU, HMCUserid, HMCUserMode);
        }
        catch (IOException e) {
            this.trace(2, TRACE_MASKF, "An error occurred during sender/receiver initialization; terminating session now.");
            this.reason = "An I/O error occurred: " + e.getMessage();
            this.eventCmd.terminate();
            this.drawCmd.terminate();
            this.closeSocket();
            this.fTerminate = true;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(InputStream input, OutputStream output, String remoteUserid, char[] remotePassword, String HMCNetId, String HMCNAU, String HMCUserid, short HMCUserMode) {
        this.trace(2, TRACE_MASKT, "-> connect(" + input + ", " + output + ", " + remoteUserid + ", <some_pwd>, " + HMCNetId + ", " + HMCNAU + ", " + HMCUserid + ", " + HMCUserMode + ")");
        this.trace(3, TRACE_MASKD, "Password=" + String.valueOf(remotePassword));
        this.reason = null;
        this.drawCmd.initialize(new BufferedInputStream(input));
        this.eventCmd.initialize(new BufferedOutputStream(output), this.client.getEnvironment());
        boolean fRc = this.negotiate(remoteUserid, remotePassword, HMCNetId, HMCNAU, HMCUserid, HMCUserMode);
        Boolean bl = this.fNegotiationSem;
        synchronized (bl) {
            this.fNegotiated = true;
            this.fNegotiationSem.notify();
        }
        if (!fRc) {
            this.trace(2, TRACE_MASKF, "Negotiation with DTOC server failed; terminating session now.");
            this.eventCmd.terminate();
            this.drawCmd.terminate();
            this.closeSocket();
            this.fTerminate = true;
            return false;
        }
        this.fStarted = true;
        this.trace(2, TRACE_MASKF, "Negotiation with DTOC server was successful");
        return this.fStarted;
    }

    public synchronized void start() {
        this.client.trace(1, TRACE_MASKT, "-> start");
        this.fInitializing = true;
        this.fTerminate = false;
        this.fReload = false;
        this.fDisconnect = false;
        this.fInsideScreen = false;
        this.fAlternateButton = false;
        this.fAlt = false;
        this.fCtrl = false;
        this.fViewOnly = false;
        this.nBrowser = 0;
        this.fMode[0] = true;
        this.fMode[1] = false;
        this.slash = (char)47;
        this.imageWidth = this.screenWidth;
        this.imageHeight = this.screenHeight;
        this.enableEvents(56L);
        this.requestFocus();
        this.bufferedImage = this.createImage(this.imageWidth, this.imageHeight);
        this.bufferedScreen = this.bufferedImage.getGraphics();
        this.bufferedScreen.setColor(new Color(255, 255, 255));
        this.bufferedScreen.fillRect(0, 0, this.imageWidth, this.imageHeight);
        this.fInitializing = false;
        this.client.trace(2, TRACE_MASKF, "about to call converter.initialize()");
        this.converter.initialize(this.drawCmd, this.eventCmd);
        this.client.trace(2, TRACE_MASKF, "about to call drawer.initialize()");
        this.drawer.initialize(this.drawCmd, this.eventCmd, this.converter, this, this.screenWidth, this.screenHeight);
        this.client.trace(1, TRACE_MASKT, "<- start");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.client.trace(1, TRACE_MASKT, "-> stop");
        try {
            master master2 = this;
            synchronized (master2) {
                if (this.fStarted) {
                    this.fStarted = false;
                    if (!this.fTerminate) {
                        this.fTerminate = true;
                        this.repaint();
                        this.eventCmd.terminate();
                        this.drawCmd.terminate();
                        this.closeSocket();
                        this.drawer.terminate();
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.client.dispose();
        this.client.trace(1, TRACE_MASKT, "<- stop");
    }

    public void disconnect() {
        this.trace(1, TRACE_MASKT, "-> disconnect");
        this.fDisconnect = true;
        this.stop();
        this.trace(1, TRACE_MASKT, "<- disconnect");
    }

    public void reload() {
        this.disconnect();
    }

    public void run() {
        this.trace(1, TRACE_MASKT, "-> run");
        while (!this.fTerminate && this.eventCmd.isValid() && this.drawCmd.isValid()) {
            this.eventCmd.watchDogTimer();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (!this.eventCmd.isValid() || !this.drawCmd.isValid()) {
            this.trace(2, TRACE_MASKF, "Probable socket error; about to call stop()");
            this.stop();
        }
        this.trace(1, TRACE_MASKT, "<- run");
    }

    boolean negotiate(String userid, char[] password, String HMCNetId, String HMCNAU, String HMCUserid, short HMCUserMode) {
        boolean isHMCEnvironment;
        short[] packetServer = new short[7];
        byte[] packetKey = new byte[4];
        byte[] packetIdPassword = new byte[36];
        byte[] packetDigest = new byte[16];
        byte[] byteKey = new byte[4];
        byte[] byteSource = new byte[24];
        MD5 md5 = new MD5();
        this.client.trace(1, TRACE_MASKT, "-> negotiate(" + userid + ", <some_pwd>, " + HMCNetId + ", " + HMCNAU + ", " + HMCUserid + ", " + HMCUserMode + ")");
        this.drawCmd.getShorts(packetServer, 7);
        this.client.trace(2, TRACE_MASKF, "Successful read of packet containing screen dimensions and server level.");
        this.screenWidth = (packetServer[3] << 8) + packetServer[2];
        this.screenHeight = (packetServer[5] << 8) + packetServer[4];
        boolean bl = isHMCEnvironment = this.client.getEnvironment() == 1;
        if (packetServer[6] == 1) {
            this.drawCmd.getBytes(packetKey, 4);
            this.client.trace(2, TRACE_MASKF, "Server version (hex): major=" + Integer.toHexString(packetServer[0]) + " " + "minor=" + Integer.toHexString(packetServer[1]));
            if (isHMCEnvironment && (packetServer[0] != 2 || packetServer[1] != 96)) {
                this.client.trace(2, TRACE_MASKF, "The DTOC server is not at the correct level for use by the HMC.");
                this.reason = "The DTOC server is not at the correct level for use by the HMC.";
                this.fAlreadyAuthenticated = false;
                return false;
            }
            while (true) {
                byte[] byteDigest;
                int i;
                boolean fOk;
                if (!this.fAlreadyAuthenticated) {
                    this.byteUserId = userid.getBytes();
                    this.bytePassword = String.valueOf(password).getBytes();
                    fOk = true;
                    if (isHMCEnvironment && (HMCNetId == null || HMCNAU == null || HMCUserid == null)) {
                        this.client.trace(2, TRACE_MASKF, "Missing required HMC user information");
                        fOk = false;
                    }
                } else {
                    fOk = true;
                }
                this.clearArray(password);
                byte[] packetHMCInfo = new byte[50];
                if (fOk) {
                    long time = System.currentTimeMillis();
                    byteKey[0] = (byte)(time >> 24 & 0xFFL);
                    byteKey[1] = (byte)(time >> 16 & 0xFFL);
                    byteKey[2] = (byte)(time >> 8 & 0xFFL);
                    byteKey[3] = (byte)(time >> 0 & 0xFFL);
                    i = 0;
                    while (i < 4) {
                        byteSource[i] = byteKey[i];
                        ++i;
                    }
                    i = 0;
                    while (i < this.bytePassword.length) {
                        byteSource[i + 4] = this.bytePassword[i];
                        ++i;
                    }
                    while (i < 16) {
                        byteSource[i + 4] = 0;
                        ++i;
                    }
                    i = 0;
                    while (i < 4) {
                        byteSource[i + 20] = packetKey[i];
                        ++i;
                    }
                    byteDigest = md5.MD5Trans(byteSource);
                    i = 0;
                    while (i < this.byteUserId.length) {
                        packetIdPassword[i] = this.byteUserId[i];
                        ++i;
                    }
                    while (i < 16) {
                        packetIdPassword[i] = 0;
                        ++i;
                    }
                    i = 0;
                    while (i < 16) {
                        packetIdPassword[i + 16] = byteDigest[i];
                        ++i;
                    }
                    i = 0;
                    while (i < 4) {
                        packetIdPassword[i + 32] = byteKey[i];
                        ++i;
                    }
                    this.client.trace(2, TRACE_MASKF, "packetIdPassword (userid(16), digest(16), key(4):");
                    this.traceByteArray(packetIdPassword);
                    this.client.trace(2, TRACE_MASKF, "About to send initial authentication packet");
                    this.eventCmd.writeBytes(packetIdPassword, 0, 36);
                    if (isHMCEnvironment) {
                        i = 0;
                        while (i < packetHMCInfo.length) {
                            packetHMCInfo[i] = 0;
                            ++i;
                        }
                        int offset = 0;
                        byte[] bytes = HMCNetId.getBytes();
                        System.arraycopy(bytes, 0, packetHMCInfo, offset, bytes.length);
                        bytes = HMCNAU.getBytes();
                        System.arraycopy(bytes, 0, packetHMCInfo, offset += 8, bytes.length);
                        bytes = HMCUserid.getBytes();
                        System.arraycopy(bytes, 0, packetHMCInfo, offset += 8, bytes.length);
                        offset += 32;
                        if (HMCUserMode == -1) {
                            packetHMCInfo[offset] = -1;
                            packetHMCInfo[offset + 1] = -1;
                        } else {
                            packetHMCInfo[offset] = (byte)(HMCUserMode / 256);
                            packetHMCInfo[offset + 1] = (byte)(HMCUserMode - HMCUserMode / 256);
                        }
                        this.client.trace(2, TRACE_MASKF, "packetHMCInfo (netId(8), NAU(8), HMCUserid(32), HMCUserMode(2)):");
                        this.traceByteArray(packetHMCInfo);
                        this.client.trace(2, TRACE_MASKF, "About to send HMC extended authentication packet");
                        this.eventCmd.writeBytes(packetHMCInfo, 0, packetHMCInfo.length);
                    }
                } else {
                    i = 0;
                    while (i < 36) {
                        packetIdPassword[i] = 0;
                        ++i;
                    }
                    this.eventCmd.writeBytes(packetIdPassword, 0, 36);
                    if (isHMCEnvironment) {
                        i = 0;
                        while (i < 50) {
                            packetHMCInfo[i] = 0;
                            ++i;
                        }
                        this.eventCmd.writeBytes(packetHMCInfo, 0, 50);
                    }
                    this.fAlreadyAuthenticated = false;
                    return false;
                }
                if (!this.drawCmd.isValid()) {
                    return false;
                }
                byte rc = this.drawCmd.getByte();
                this.client.trace(2, TRACE_MASKF, "Authentication rc from server = " + rc);
                byte[] errorData = null;
                switch (rc) {
                    case 0: {
                        this.drawCmd.getBytes(packetDigest, 16);
                        i = 0;
                        while (i < 4) {
                            byteSource[i] = packetKey[i];
                            ++i;
                        }
                        i = 0;
                        while (i < this.bytePassword.length) {
                            byteSource[i + 4] = this.bytePassword[i];
                            ++i;
                        }
                        while (i < 16) {
                            byteSource[i + 4] = 0;
                            ++i;
                        }
                        i = 0;
                        while (i < 4) {
                            byteSource[i + 20] = byteKey[i];
                            ++i;
                        }
                        byteDigest = md5.MD5Trans(byteSource);
                        i = 0;
                        while (i < 16) {
                            if (byteDigest[i] != packetDigest[i]) {
                                this.reason = "Incorrect userid and/or password";
                                this.client.trace(2, TRACE_MASKF, "Login failure reason = \"" + this.reason + "\"");
                                this.fAlreadyAuthenticated = false;
                                return false;
                            }
                            ++i;
                        }
                        this.fAlreadyAuthenticated = true;
                        return true;
                    }
                    case 1: {
                        this.reason = "Incorrect userid and/or password";
                        this.client.trace(2, TRACE_MASKF, "Login failure reason = \"" + this.reason + "\"");
                        this.fAlreadyAuthenticated = false;
                        return false;
                    }
                    case 2: {
                        this.fAlreadyAuthenticated = false;
                        return false;
                    }
                    case 3: {
                        this.reason = "A user is already logged onto the SE locally.  The SE userid is not known.";
                        try {
                            String SEUser;
                            errorData = this.getErrorData();
                            if (errorData != null && (SEUser = this.getString(errorData, 0)).length() != 0) {
                                this.reason = "User " + SEUser + " is already logged onto the SE locally.";
                            }
                        }
                        catch (ErrorDataException ede) {
                            // empty catch block
                        }
                        this.client.trace(2, TRACE_MASKF, "Login failure reason = \"" + this.reason + "\"");
                        this.fAlreadyAuthenticated = false;
                        return false;
                    }
                    case 4: {
                        this.reason = "A user is already logged onto the SE remotely through DCAF.  The HMC identity is not known.";
                        try {
                            errorData = this.getErrorData();
                            if (errorData != null) {
                                String netId = this.getString(errorData, 0);
                                String NAU = this.getString(errorData, netId.length() + 1);
                                if (netId.length() != 0 && NAU.length() != 0) {
                                    this.reason = "A user from HMC " + netId + "." + NAU + " is already logged onto the SE remotely through DCAF.";
                                }
                            }
                        }
                        catch (ErrorDataException ede) {
                            // empty catch block
                        }
                        this.client.trace(2, TRACE_MASKF, "Login failure reason = \"" + this.reason + "\"");
                        this.fAlreadyAuthenticated = false;
                        return false;
                    }
                    case 5: {
                        this.reason = "A user is already logged onto the SE remotely through DTOC.  The user's identity is not known.";
                        try {
                            errorData = this.getErrorData();
                            if (errorData != null) {
                                int offset = 0;
                                String IPAddress = this.getString(errorData, offset);
                                String HMCUser = this.getString(errorData, offset += IPAddress.length() + 1);
                                String netId = this.getString(errorData, offset += HMCUser.length() + 1);
                                String NAU = this.getString(errorData, offset += netId.length() + 1);
                                String SEUser = this.getString(errorData, offset += NAU.length() + 1);
                                StringBuffer sb = new StringBuffer();
                                sb.append("A user is already logged onto the SE remotely through DTOC.");
                                sb.append("  Client IP address = " + (IPAddress.length() != 0 ? IPAddress : "<not known>") + ".");
                                sb.append("  HMC userid = " + (HMCUser.length() != 0 ? HMCUser : "<not known>") + ".");
                                sb.append("  HMC netId = " + (netId.length() != 0 ? netId : "<not known>") + ".");
                                sb.append("  HMC NAU = " + (NAU.length() != 0 ? NAU : "<not known>") + ".");
                                sb.append("  SE userid = " + (SEUser.length() != 0 ? SEUser : "<not known>") + ".");
                                this.reason = sb.toString();
                            }
                        }
                        catch (ErrorDataException ede) {
                            // empty catch block
                        }
                        this.client.trace(2, TRACE_MASKF, "Login failure reason = \"" + this.reason + "\"");
                        this.fAlreadyAuthenticated = false;
                        return false;
                    }
                    case 6: {
                        this.reason = "The HMC userid (" + HMCUserid + ") is not defined on the SE" + (HMCUserMode != -1 ? ", and the user mode (" + HMCUserMode + ") is not defined on the SE." : ".");
                        try {
                            errorData = this.getErrorData();
                        }
                        catch (ErrorDataException ede) {
                            this.reason = ede.getMessage();
                        }
                        this.client.trace(2, TRACE_MASKF, "Login failure reason = \"" + this.reason + "\"");
                        this.fAlreadyAuthenticated = false;
                        return false;
                    }
                    case 7: {
                        this.reason = "An unrecoverable internal error occurred on the SE.";
                        try {
                            errorData = this.getErrorData();
                        }
                        catch (ErrorDataException ede) {
                            this.reason = ede.getMessage();
                        }
                        this.client.trace(2, TRACE_MASKF, "Login failure reason = \"" + this.reason + "\"");
                        this.fAlreadyAuthenticated = false;
                        return false;
                    }
                }
            }
        }
        this.fAlreadyAuthenticated = false;
        this.clearArray(password);
        if (isHMCEnvironment && (packetServer[0] != 2 || packetServer[1] != 96)) {
            this.reason = "The DTOC server is not at the correct level for use by the HMC.";
            return false;
        }
        return true;
    }

    public String getConnectFailureMessage() {
        return this.reason;
    }

    private byte[] getErrorData() throws ErrorDataException {
        if (!this.drawCmd.isValid()) {
            String reason = new String("Unable to receive error data byte count");
            this.client.trace(2, TRACE_MASKF, reason);
            throw new ErrorDataException(reason);
        }
        byte count = this.drawCmd.getByte();
        byte[] data = new byte[count];
        this.client.trace(2, TRACE_MASKF, "Length of error data=" + count);
        if (count != 0) {
            if (!this.drawCmd.isValid()) {
                String reason = new String("Unable to receive any error data; should be " + count + " bytes");
                this.client.trace(2, TRACE_MASKF, reason);
                throw new ErrorDataException(reason);
            }
            this.drawCmd.getBytes(data, count);
            this.client.trace(2, TRACE_MASKF, "Error data from server=" + new String(data));
            this.traceByteArray(data);
        }
        return data;
    }

    private void traceByteArray(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            String s;
            byte b = bytes[i];
            if (b == 0) {
                s = " ";
            } else if (b == -1) {
                s = "-1";
            } else {
                byte[] t = new byte[]{(byte)Math.abs(b)};
                s = new String(t);
            }
            this.client.trace(2, TRACE_MASKF, s + " " + Integer.toHexString(b) + " " + b);
            ++i;
        }
    }

    private String getString(byte[] bytes, int offset) {
        int cnt = 0;
        int i = 0;
        while (i + offset < bytes.length && bytes[i + offset] != 0) {
            ++i;
            ++cnt;
        }
        byte[] sb = new byte[cnt];
        System.arraycopy(bytes, offset, sb, 0, cnt);
        return new String(sb);
    }

    private void clearArray(char[] array) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                array[i] = '\u0000';
                ++i;
            }
        }
    }

    public boolean isConnected() {
        return this.fStarted && !this.fTerminate;
    }

    public void update(Graphics screen) {
        this.paint(screen);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.screenWidth, this.screenHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics screen) {
        Rectangle clipBounds = screen.getClipBounds();
        if (this.fInitializing || !this.fNegotiated) {
            screen.setColor(new Color(255, 255, 255));
            screen.clipRect(0, 0, this.imageWidth, this.imageHeight);
            screen.fillRect(0, 0, this.imageWidth, this.imageHeight);
        } else if (this.fTerminate || this.fReload || this.fDisconnect) {
            screen.setColor(new Color(255, 255, 255));
            screen.clipRect(0, 0, this.imageWidth, this.imageHeight);
            screen.fillRect(0, 0, this.imageWidth, this.imageHeight);
            if (!this.fReload) {
                if (this.fDisconnect) {
                    this.drawInfoBox("Disconnected.");
                } else {
                    this.drawInfoBox("Connection failure.");
                }
            }
            screen.clipRect(0, 0, this.imageWidth, this.imageHeight);
            screen.drawImage(this.bufferedImage, 0, 0, this);
        } else if (this.screenWidth > 0) {
            Boolean bl = this.drawer.fDrawn;
            synchronized (bl) {
                int width = this.drawer.right - this.drawer.left + 1;
                int height = this.drawer.bottom - this.drawer.top + 1;
                if (this.drawer.fAvailable) {
                    screen.drawImage(this.bufferedImage, 0, 0, this);
                    this.drawer.fAvailable = false;
                    this.drawer.fDrawn.notify();
                } else {
                    screen.drawImage(this.bufferedImage, 0, 0, this);
                }
            }
        }
    }

    void drawInfoBox(String message) {
        int width = this.imageWidth >= 660 ? 640 : this.imageWidth - 20;
        int posX = this.imageWidth - width - 20 >> 1;
        int posY = this.imageHeight - 68 >> 1;
        this.bufferedScreen.setColor(new Color(255, 255, 255));
        this.bufferedScreen.fillRect(0, 0, this.imageWidth, this.imageHeight);
        this.bufferedScreen.setColor(new Color(192, 192, 192));
        this.bufferedScreen.fillRect(posX, posY, width, 48);
        this.bufferedScreen.draw3DRect(posX + 1, posY + 1, width - 2, 46, true);
        this.bufferedScreen.setColor(new Color(0, 0, 0));
        this.bufferedScreen.drawRect(posX, posY, width, 48);
        Font font = new Font("Helvetica", 1, 24);
        this.bufferedScreen.setFont(font);
        this.bufferedScreen.setColor(new Color(128, 128, 128));
        this.bufferedScreen.drawString(message, posX + 10 + 2, posY + 48 - 17 + 2);
        this.bufferedScreen.setColor(new Color(255, 255, 255));
        this.bufferedScreen.drawString(message, posX + 10, posY + 48 - 17);
    }

    public boolean isPictureReady(int n) {
        return this.imageTracker.checkID(n, true);
    }

    void myMouseDown(int x, int y, int modifiers) {
        if (x < this.screenWidth && y < this.screenHeight && !this.fViewOnly) {
            this.eventCmd.mouseMove((short)x, (short)(this.screenHeight - y - 1));
            byte modifier = (byte)(modifiers & 3);
            modifier = (byte)(modifier | (byte)(this.fAlt ? 4 : 0));
            modifier = (byte)(modifier | (byte)(this.fCtrl ? 2 : 0));
            this.fAlternateButton = (modifiers & 4) != 0;
            if (this.fMode[1]) {
                if (this.fAlternateButton) {
                    this.eventCmd.mouseDown1(modifier);
                } else {
                    this.eventCmd.mouseDown2(modifier);
                }
            } else if (this.fAlternateButton) {
                this.eventCmd.mouseDown2(modifier);
            } else {
                this.eventCmd.mouseDown1(modifier);
            }
        }
    }

    void myMouseUp(int x, int y, int modifiers) {
        if (x < this.screenWidth && y < this.screenHeight) {
            if (!this.fViewOnly) {
                this.eventCmd.mouseMove((short)x, (short)(this.screenHeight - y - 1));
                byte modifier = (byte)(modifiers & 3);
                modifier = (byte)(modifier | (byte)(this.fAlt ? 4 : 0));
                modifier = (byte)(modifier | (byte)(this.fCtrl ? 2 : 0));
                if (this.fMode[1]) {
                    if (this.fAlternateButton) {
                        this.eventCmd.mouseUp1(modifier);
                    } else {
                        this.eventCmd.mouseUp2(modifier);
                    }
                } else if (this.fAlternateButton) {
                    this.eventCmd.mouseUp2(modifier);
                } else {
                    this.eventCmd.mouseUp1(modifier);
                }
            }
            if (this.fAlt) {
                this.fAlt = false;
                this.repaint();
            }
            if (this.fCtrl) {
                this.fCtrl = false;
                this.repaint();
            }
        }
    }

    void myMouseMove(int x, int y, int modifiers) {
        if (x < this.screenWidth && y < this.screenHeight) {
            this.fInsideScreen = true;
            this.lastX = x;
            this.lastY = this.screenHeight - y - 1;
            if (!this.fViewOnly) {
                this.eventCmd.mouseMove((short)this.lastX, (short)this.lastY);
            }
        } else {
            if (this.fInsideScreen) {
                if (x >= this.screenWidth && y >= this.screenHeight) {
                    this.eventCmd.mouseMove((short)(this.screenWidth - 1), (short)0);
                } else if (x >= this.screenWidth) {
                    this.eventCmd.mouseMove((short)(this.screenWidth - 1), (short)this.lastY);
                } else if (y >= this.screenHeight) {
                    this.eventCmd.mouseMove((short)this.lastX, (short)0);
                }
                this.fInsideScreen = false;
            }
            boolean fOnTheButtons = false;
        }
    }

    void myMouseDrag(int x, int y, int modifiers) {
        if (x < this.screenWidth && y < this.screenHeight) {
            this.eventCmd.mouseDrag((short)x, (short)(this.screenHeight - y - 1));
        }
    }

    void myMouseEnter(int x, int y, int modifiers) {
        this.eventCmd.mouseEnter();
    }

    void myMouseExit(int x, int y, int modifiers) {
        if (this.fInsideScreen) {
            if (x <= 0 && y <= 0) {
                this.eventCmd.mouseMove((short)0, (short)(this.screenHeight - 1));
            } else if (x >= this.screenWidth && y <= 0) {
                this.eventCmd.mouseMove((short)(this.screenWidth - 1), (short)(this.screenHeight - 1));
            } else if (x <= 0 && y <= this.screenHeight) {
                this.eventCmd.mouseMove((short)0, (short)0);
            } else if (x >= this.screenWidth && y >= this.screenHeight) {
                this.eventCmd.mouseMove((short)(this.screenWidth - 1), (short)0);
            } else if (x <= 0) {
                this.eventCmd.mouseMove((short)0, (short)this.lastY);
            } else if (y <= 0) {
                this.eventCmd.mouseMove((short)this.lastX, (short)(this.screenHeight - 1));
            } else if (x >= this.screenWidth) {
                this.eventCmd.mouseMove((short)(this.screenWidth - 1), (short)this.lastY);
            } else if (y >= this.screenHeight) {
                this.eventCmd.mouseMove((short)this.lastX, (short)0);
            }
            this.fInsideScreen = false;
        }
        this.eventCmd.mouseExit();
    }

    void myKeyPress(int code, int key, int modifiers) {
        byte modifier = (byte)modifiers;
        modifier = (byte)(modifier | (byte)(this.fAlt ? 4 : 0));
        modifier = (byte)(modifier | (byte)(this.fCtrl ? 2 : 0));
        switch (code) {
            case 16: {
                break;
            }
            case 18: {
                break;
            }
            case 17: {
                break;
            }
            case 157: {
                break;
            }
            case 24: {
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 21: {
                break;
            }
            case 25: {
                break;
            }
            case 36: {
                this.eventCmd.keyPress((byte)0, modifier);
                break;
            }
            case 35: {
                this.eventCmd.keyPress((byte)1, modifier);
                break;
            }
            case 33: {
                this.eventCmd.keyPress((byte)2, modifier);
                break;
            }
            case 34: {
                this.eventCmd.keyPress((byte)3, modifier);
                break;
            }
            case 38: {
                this.eventCmd.keyPress((byte)4, modifier);
                break;
            }
            case 40: {
                this.eventCmd.keyPress((byte)5, modifier);
                break;
            }
            case 37: {
                this.eventCmd.keyPress((byte)6, modifier);
                break;
            }
            case 39: {
                this.eventCmd.keyPress((byte)7, modifier);
                break;
            }
            case 8: {
                this.eventCmd.keyPress((byte)8, modifier);
                break;
            }
            case 9: {
                this.eventCmd.keyPress((byte)9, modifier);
                break;
            }
            case 10: {
                this.eventCmd.keyPress((byte)10, modifier);
                break;
            }
            case 155: {
                this.eventCmd.keyPress((byte)14, modifier);
                break;
            }
            case 112: {
                this.eventCmd.keyPress((byte)17, modifier);
                break;
            }
            case 113: {
                this.eventCmd.keyPress((byte)18, modifier);
                break;
            }
            case 114: {
                this.eventCmd.keyPress((byte)19, modifier);
                break;
            }
            case 115: {
                this.eventCmd.keyPress((byte)20, modifier);
                break;
            }
            case 116: {
                this.eventCmd.keyPress((byte)21, modifier);
                break;
            }
            case 117: {
                this.eventCmd.keyPress((byte)22, modifier);
                break;
            }
            case 118: {
                this.eventCmd.keyPress((byte)23, modifier);
                break;
            }
            case 119: {
                this.eventCmd.keyPress((byte)24, modifier);
                break;
            }
            case 120: {
                this.eventCmd.keyPress((byte)25, modifier);
                break;
            }
            case 121: {
                this.eventCmd.keyPress((byte)26, modifier);
                break;
            }
            case 27: {
                this.eventCmd.keyPress((byte)27, modifier);
                break;
            }
            case 122: {
                this.eventCmd.keyPress((byte)28, modifier);
                break;
            }
            case 123: {
                this.eventCmd.keyPress((byte)29, modifier);
                break;
            }
            case 127: {
                this.eventCmd.keyPress((byte)127, modifier);
                break;
            }
            default: {
                this.eventCmd.keyPress((byte)key, modifier);
            }
        }
    }

    void myKeyRelease(int code, int key, int modifiers) {
        byte modifier = (byte)modifiers;
        modifier = (byte)(modifier | (byte)(this.fAlt ? 4 : 0));
        modifier = (byte)(modifier | (byte)(this.fCtrl ? 2 : 0));
        switch (code) {
            case 16: {
                break;
            }
            case 18: {
                break;
            }
            case 17: {
                break;
            }
            case 157: {
                break;
            }
            case 24: {
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 21: {
                break;
            }
            case 25: {
                break;
            }
            case 36: {
                this.eventCmd.keyRelease((byte)0, modifier);
                break;
            }
            case 35: {
                this.eventCmd.keyRelease((byte)1, modifier);
                break;
            }
            case 33: {
                this.eventCmd.keyRelease((byte)2, modifier);
                break;
            }
            case 34: {
                this.eventCmd.keyRelease((byte)3, modifier);
                break;
            }
            case 38: {
                this.eventCmd.keyRelease((byte)4, modifier);
                break;
            }
            case 40: {
                this.eventCmd.keyRelease((byte)5, modifier);
                break;
            }
            case 37: {
                this.eventCmd.keyRelease((byte)6, modifier);
                break;
            }
            case 39: {
                this.eventCmd.keyRelease((byte)7, modifier);
                break;
            }
            case 8: {
                this.eventCmd.keyRelease((byte)8, modifier);
                break;
            }
            case 9: {
                this.eventCmd.keyRelease((byte)9, modifier);
                break;
            }
            case 10: {
                this.eventCmd.keyRelease((byte)10, modifier);
                break;
            }
            case 155: {
                this.eventCmd.keyRelease((byte)14, modifier);
                break;
            }
            case 112: {
                this.eventCmd.keyRelease((byte)17, modifier);
                break;
            }
            case 113: {
                this.eventCmd.keyRelease((byte)18, modifier);
                break;
            }
            case 114: {
                this.eventCmd.keyRelease((byte)19, modifier);
                break;
            }
            case 115: {
                this.eventCmd.keyRelease((byte)20, modifier);
                break;
            }
            case 116: {
                this.eventCmd.keyRelease((byte)21, modifier);
                break;
            }
            case 117: {
                this.eventCmd.keyRelease((byte)22, modifier);
                break;
            }
            case 118: {
                this.eventCmd.keyRelease((byte)23, modifier);
                break;
            }
            case 119: {
                this.eventCmd.keyRelease((byte)24, modifier);
                break;
            }
            case 120: {
                this.eventCmd.keyRelease((byte)25, modifier);
                break;
            }
            case 121: {
                this.eventCmd.keyRelease((byte)26, modifier);
                break;
            }
            case 27: {
                this.eventCmd.keyRelease((byte)27, modifier);
                break;
            }
            case 122: {
                this.eventCmd.keyRelease((byte)28, modifier);
                break;
            }
            case 123: {
                this.eventCmd.keyRelease((byte)29, modifier);
                break;
            }
            case 127: {
                this.eventCmd.keyRelease((byte)127, modifier);
                break;
            }
            default: {
                this.eventCmd.keyRelease((byte)key, modifier);
            }
        }
        if (this.fAlt) {
            this.fAlt = false;
            this.repaint();
        }
        if (this.fCtrl) {
            this.fCtrl = false;
            this.repaint();
        }
    }

    public void processMouseEvent(MouseEvent evt) {
        if (!this.fTerminate && this.fStarted) {
            switch (evt.getID()) {
                case 501: {
                    this.requestFocus();
                    this.myMouseDown(evt.getX(), evt.getY(), evt.getModifiers());
                    break;
                }
                case 502: {
                    this.myMouseUp(evt.getX(), evt.getY(), evt.getModifiers());
                }
            }
        }
    }

    public void processMouseMotionEvent(MouseEvent evt) {
        if (!(this.fTerminate || !this.fStarted || this.fViewOnly && evt.getID() != 503)) {
            switch (evt.getID()) {
                case 503: {
                    this.myMouseMove(evt.getX(), evt.getY(), evt.getModifiers());
                    break;
                }
                case 506: {
                    this.myMouseDrag(evt.getX(), evt.getY(), evt.getModifiers());
                    break;
                }
                case 504: {
                    this.myMouseEnter(evt.getX(), evt.getY(), evt.getModifiers());
                    break;
                }
                case 505: {
                    this.myMouseExit(evt.getX(), evt.getY(), evt.getModifiers());
                }
            }
        }
    }

    public void processKeyEvent(KeyEvent evt) {
        if (!this.fTerminate && this.fStarted && !this.fViewOnly) {
            switch (evt.getID()) {
                case 401: {
                    this.myKeyPress(evt.getKeyCode(), evt.getKeyChar(), evt.getModifiers());
                    break;
                }
                case 402: {
                    this.myKeyRelease(evt.getKeyCode(), evt.getKeyChar(), evt.getModifiers());
                    break;
                }
            }
        }
    }

    private Socket openSocket(String host, int port) {
        this.trace(1, TRACE_MASKT, "-> openSocket(" + host + ", " + port + ")");
        Socket s0 = null;
        try {
            s0 = new Socket(host, port);
        }
        catch (UnknownHostException e) {
            this.trace(2, TRACE_MASKF, "Caught UnknownHostException: " + e.getMessage());
            this.reason = "The host is not valid: " + host;
            s0 = null;
        }
        catch (IOException e) {
            this.trace(2, TRACE_MASKF, "Caught IOException: " + e.getMessage());
            this.reason = "An I/O error occurred: " + e.getMessage();
            s0 = null;
        }
        catch (IllegalArgumentException e) {
            this.trace(2, TRACE_MASKF, "Caught IllegalArgumentException: " + e.getMessage());
            this.reason = e.getMessage();
            s0 = null;
        }
        this.trace(1, TRACE_MASKT, "<- openSocket() returning with socket=" + s0);
        return s0;
    }

    private void closeSocket() {
        this.trace(1, TRACE_MASKT, "-> closeSocket");
        try {
            if (this.output != null) {
                this.trace(3, TRACE_MASKT, "About to close connection to DTOC server");
                this.output.close();
                this.input.close();
            }
        }
        catch (IOException e) {
            this.trace(2, TRACE_MASKF, "IOException in closeSocket(): " + e.getMessage());
        }
        this.trace(1, TRACE_MASKT, "<- closeSocket");
    }
}

